<?php
/**
 * dr_choo functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package dr_choo
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

if ( ! function_exists( 'dr_choo_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function dr_choo_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on dr_choo, use a find and replace
		 * to change 'dr_choo' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'dr_choo', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'primary' => esc_html__( 'Primary', 'dr_choo' ),
				'mobile' => esc_html__( 'Mobile', 'dr_choo' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'dr_choo_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'dr_choo_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function dr_choo_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'dr_choo_content_width', 640 );
}
add_action( 'after_setup_theme', 'dr_choo_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function dr_choo_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'dr_choo' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'dr_choo' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'dr_choo_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function dr_choo_scripts() {
	
	wp_enqueue_style( 'dr_choo-metismenu', get_template_directory_uri().'/CSS/metismenu.css' );
	//wp_enqueue_style( 'dr_choo-style-cm', get_template_directory_uri().'/CSS/style.css' );
	wp_enqueue_style( 'dr_choo-fonts', get_template_directory_uri().'/CSS/fonts.css' );
	wp_enqueue_style( 'dr_choo-bootstrap', get_template_directory_uri().'/CSS/bootstrap.min.css' );
	wp_enqueue_style( 'dr_choo-style-cm', get_template_directory_uri().'/CSS/style.css' );
	
	wp_enqueue_style( 'dr_choo-style', get_stylesheet_uri() );

	wp_style_add_data( 'dr_choo-style', 'rtl', 'replace' );

	wp_enqueue_script( 'dr_choo-jquery-js', get_template_directory_uri() . '/js/jquery.min.js');
	wp_enqueue_script( 'dr_choo-owl-carousel-js', get_template_directory_uri() . '/js/owl-carousel.js' );
		wp_enqueue_style( 'dr_choo-owl-carousel-cs', get_template_directory_uri().'/CSS/owl-carousel.css' );
	wp_enqueue_script( 'dr_choo-tether', get_template_directory_uri() . '/js/tether.min.js', array(), '', true);
	wp_enqueue_script( 'dr_choo-bootstrap-js', get_template_directory_uri() . '/js/bootstrap.min.js', array(), '', true);
	wp_enqueue_script( 'dr_choo-matchHeight-js', get_template_directory_uri() . '/js/jquery.matchHeight.js', array(), '', true);
	wp_enqueue_script( 'dr_choo-metismenu-js', get_template_directory_uri() . '/js/metismenu.js', array(), '', true);
	wp_enqueue_script( 'dr_choo-custom', get_template_directory_uri() . '/js/custom.js', array(), '', true);

	wp_enqueue_script( 'dr_choo-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '', true );
	
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	if ( is_page_template( 'home-template-new.php' ) ) {	
		wp_enqueue_script( 'home_template_specific_js', get_template_directory_uri() . '/js/homepage_custom.js' );
		
   		wp_enqueue_style( 'home_template_specific_css', get_template_directory_uri() . '/CSS/homepage_custom_style.css' );
		
	}
	
	
}
add_action( 'wp_enqueue_scripts', 'dr_choo_scripts' );


// 	function wpse_enqueue_page_template_styles() {
//     if ( is_page_template( 'home-template-new.php' ) ) {		
//         wp_enqueue_style( 'home_template_specific_css', get_stylesheet_directory_uri() . '/CSS/homepage_custom_style.css' );
//     }
// }
// add_action( 'wp_enqueue_scripts', 'wpse_enqueue_page_template_styles' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

if( function_exists('acf_add_options_page') ) {
	
	acf_add_options_page(array(
		'page_title' 	=> 'Theme Settings',
		'menu_title'	=> 'Theme Settings',
		'menu_slug' 	=> 'theme-settings',
		'capability'	=> 'edit_posts',
		'redirect'		=> false
	));
	
	
}
/*
* Creating a function to create our CPT
*/
 
function custom_post_type() {
 
// Set UI labels for Custom Post Type
    $labels = array(
        'name'                => _x( 'Service', 'Post Type General Name', 'dr_choo' ),
        'singular_name'       => _x( 'Service', 'Post Type Singular Name', 'dr_choo' ),
        'menu_name'           => __( 'Service', 'dr_choo' ),
        'parent_item_colon'   => __( 'Parent Service', 'dr_choo' ),
        'all_items'           => __( 'All Service', 'dr_choo' ),
        'view_item'           => __( 'View Service', 'dr_choo' ),
        'add_new_item'        => __( 'Add New Service', 'dr_choo' ),
        'add_new'             => __( 'Add New', 'dr_choo' ),
        'edit_item'           => __( 'Edit Service', 'dr_choo' ),
        'update_item'         => __( 'Update Service', 'dr_choo' ),
        'search_items'        => __( 'Search Service', 'dr_choo' ),
        'not_found'           => __( 'Not Found', 'dr_choo' ),
        'not_found_in_trash'  => __( 'Not found in Trash', 'dr_choo' ),
    );
     
// Set other options for Custom Post Type
     
    $args = array(
        'label'               => __( 'Service', 'dr_choo' ),
        'description'         => __( 'Service news and reviews', 'dr_choo' ),
        'labels'              => $labels,
        'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
        'taxonomies'          => array( 'genres' ),
        'hierarchical'        => false,
        'public'              => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'show_in_nav_menus'   => true,
        'show_in_admin_bar'   => true,
        'menu_position'       => 5,
        'can_export'          => true,
        'has_archive'         => true,
        'exclude_from_search' => false,
        'publicly_queryable'  => true,
        'capability_type'     => 'post',
        'show_in_rest' => true,
 
    );
     
    // Registering your Custom Post Type
    register_post_type( 'Service', $args );
 
}

 
add_action( 'init', 'custom_post_type', 0 );

add_filter( 'nav_menu_css_class', 'menu_item_classes', 10, 4 );

function menu_item_classes( $classes, $item, $args, $depth ) {

    //unset($classes);

    $classes[] = 'nav-item';

    return $classes;
}
function my_nav_menu_submenu_css_class( $classes ) {
    $classes[] = 'submenu metismenu';
    return $classes;
}
add_filter( 'nav_menu_submenu_css_class', 'my_nav_menu_submenu_css_class' );


function add_modified_time( $src ) {

    $clean_src = remove_query_arg( 'ver', $src );
    $path      = wp_parse_url( $src, PHP_URL_PATH );

    if ( $modified_time = @filemtime( untrailingslashit( ABSPATH ) . $path ) ) {
        $src = add_query_arg( 'ver', $modified_time, $clean_src );
    } else {
        $src = add_query_arg( 'ver', time(), $clean_src );
    }

    return $src;

}

add_filter( 'style_loader_src', 'add_modified_time', 99999999, 1 );


function cf7_footer_script(){ 
 
//if page name is contact.
if ( is_page(18)) {?>
  
   	<script>
		document.addEventListener( 'wpcf7mailsent', function( event ) {
		    
		    var inputs = event.detail.inputs;
		    location = 'https://drchoowl.com.sg/thank-you/';
		    for ( var i = 0; i < inputs.length; i++ ) {
		    	if ( 'your-name' == inputs[i].name ) {
		                var Preferred_Doctor = inputs[i].value;
		                location = 'https://drchoowl.com.sg/thank-you?ss='+Preferred_Doctor;
		            }
			}
			
		}, false );
		</script>
<?php } 
     
}
add_action('wp_footer', 'cf7_footer_script');

add_action( 'wpcf7_before_send_mail',
  function( $contact_form, $abort, $submission ) {
    // Getting user input through the your-email field
    $your_email = $submission->get_posted_data( 'your-name' );
 
  },
  10, 3
);