<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package dr_choo
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T3G889Z');</script>
<!-- End Google Tag Manager -->
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<link href="https://fonts.googleapis.com/css?family=Lato:300,400&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Advent+Pro:400,600&display=swap" rel="stylesheet">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T3G889Z"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	<!----
<div class="app-container">
    	<div class="content-container">
			
    		<div class="side-menu sidebar-inverse">
    			<nav class="navbar-default">
    				<div class="side-menu-container">
    					<div class="navbar-header">
    						<h4>MENU</h4>
    						<div class="close-menu-icon"></div>
    					</div>
    					 <ul class="metismenu" id="side-menu">
    						<li><a href="index.html">Home</a></li>
    						<li><a href="team.html">About Dr Choo</a></li>
    						<li><a href="#" class="has-arrow">Services</a>
    							<ul>
    								<li><a href="service.html">Obstetrics</a></li>
    								<li><a href="service.html">Gynaecology</a> </li>
                                    <li><a href="service.html">Fertility Treatments</a> </li>
    							</ul>
    						</li>
    						<li class="nav-item"><a href="contact.html">Contact Us</a></li>
    					</ul> 
  					<?php wp_nav_menu( array('theme_location' => 'mobile', 'container' => false, 'items_wrap' => '<ul class="metismenu" id="side-menu">%3$s</ul>', 'depth' => 0, 'walker' => '')); ?>
    				</div>
    			</nav>
    		</div>
    	</div>
    </div>  ---> 
    <header class="WFwrap stickywrap headenew">
        <div class="container">
    		<div class="primary-nav">
    			<div class="SiteLogo">
    				<a href="<?php echo get_home_url();?>">
    					<img src="<?php echo get_field('site_logo','option'); ?>" alt="SiteLogo">
    				</a>
    			</div>
                
    			<div class="navbar-expand-toggle"></div>
    			<div class="SiteMenu">
<!--     				<nav class="nav-menu">
    					 <?php wp_nav_menu( array('theme_location' => 'primary', 'container' => false, 'items_wrap' => '<ul class="navbar">%3$s</ul>', 'depth' => 0, 'walker' => '')); ?>
    				</nav> -->
    			</div>
				
    			<div class="header_contact_area">
					<div class="header_number sog_dr_cho_li_wei_landing_call_btn">
						
					<?php $call_t =  get_field('call_t','option'); ?>
					<span><img src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/01/phone-icon.png"></span><span>
 					<strong>Call Us</strong> <a href="tel:<?php echo $call_t['title']; ?>"><?php echo $call_t['title']; ?></a>
					</span>
					</div>
					<div class="header_contact header_home_contact">
    				<?php 
    				$header_right_button =  get_field('header_right_button','option');
    				if(!empty($header_right_button)){
    					?>
    				<a href="<?php echo $header_right_button['url']; ?>" class="contactus mb_header_btn btn btntop">
    				<?php echo $header_right_button['title']; ?></a>	
    					<?php
    				}
    				?>
    			</div>
					<div class="header_contact header_thanks_contact">
    				<?php 
    				$header_right_button =  get_field('header_right_button','option');
    				if(!empty($header_right_button)){
    					?>
    				<a href="<?php echo $header_right_button['url']; ?>" class="contactus mb_header_btn btn btntop">
    				<?php echo $header_right_button['title']; ?></a>	
    					<?php
    				}
    				?>
    			</div>
    				
    			</div>

    		</div>
        </div>
    </header>