<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package dr_choo
 */

get_header(); 
$fields = get_fields(get_the_ID());

while ( have_posts() ) : the_post();
?>
<section class="WFwrap imp_functions">
        <div class="container">
            <div class="row imp_function_row">
                <div class="col-md-6 col-sm-12 imp_fun_grid imp_fun_img">
                	<?php echo get_the_post_thumbnail(); ?>
                   <!--  <figure><img src=""></figure> -->
                </div>
                <div class="col-md-6 col-sm-12 imp_fun_grid imp_fun_dec">
                    <h1><?php echo $fields['banner_title'];?></h1>
                   	<?php echo $fields['banner_dec'];?>
                   	<?php $banner_link =  $fields['banner_link'];?>
                    <a href="<?php echo $banner_link['url']; ?>" class="btn"><?php echo $banner_link['title']; ?></a>
                </div>
            </div>
        </div>
    </section>  
    <section class="WFwrap service_offer">
        <div class="container">
            <div class="row ">
                <div class="col-md-6 col-sm-12 service_offer_dec">
                    <div class="offer_div">
					<h2><?php echo $fields['offer_title'];?></h2>
                    <?php echo $fields['offer_dec'];?>
                    <?php $offer_link =  $fields['offer_link'];?>
                    <a href="<?php echo $offer_link['url']; ?>" class="btn desktop"><?php echo $offer_link['title']; ?></a>
					</div>
                </div>
                <div class="col-md-6 col-sm-12 service_offer_list">
                    <ul>
                    	<?php
                    	 $offer_lists = $fields['offer_list'];
                            foreach( $offer_lists as $offer_list ) { ?>
                            	<li><?php echo $offer_list['list']; ?></li>
                            <?php }
                    	 ?>
                    </ul>
                    <a href="<?php echo $offer_link['url']; ?>" class="btn mobile"><?php echo $offer_link['title']; ?></a>
                </div>
            </div>
        </div>
    </section>
    <section class="WFwrap about_dr_section">
        <div class="container">
            <div class="row">
                <div class="col-md-6 col-sm-12 about_dr_img">
                    <figure>
                    <img src="<?php the_field('dr_image','option'); ?>">
                    </figure>
                </div>
                <div class="col-md-6 col-sm-12 about_dr_contain">
                        <div class="title">
                            <?php the_field('dr_title','option'); ?>
                        </div>
                        <p class="study"><?php the_field('dr_study','option'); ?></p>
                        <?php the_field('dr_dec','option'); 
                       	$dr_link = get_field('dr_link','option');
                        ?>
                        <a href="<?php echo $dr_link['url']; ?>" class="btn"><?php echo $dr_link['title']; ?></a>
                </div>
            </div>
        </div>
    </section>
    <section class="WFwrap contact_section">
        <div class="container">
            <div class="row">
                <div class="col-md-5 col-sm-12 contact_detail_grid">
                    <h2>Our Location</h2>
                    <ul>
                        <li>
                            <figure><img src="<?php echo get_template_directory_uri(); ?>/image/location.svg"></figure>
                            <?php the_field('address','option'); ?>
                        </li>
                        <li>
                            <figure><img src="<?php echo get_template_directory_uri(); ?>/image/call.svg"></figure>
                            <?php $call_t =  get_field('call_t','option');$call_e =  get_field('call_e','option'); ?>
                            T : <a href="tel:<?php echo $call_t['url']; ?>"><?php echo $call_t['title']; ?></a><br>  
                            F : <?php the_field('call_f','option'); ?><br>
                            E : <a href="tel:<?php echo $call_e['url']; ?>"><?php echo $call_e['title']; ?></a>
                        </li>
                        <li>
                            <figure><img src="<?php echo get_template_directory_uri(); ?>/image/clock.svg"></figure><?php the_field('timer','option'); ?>
                        </li>
                        <li class="email-img">
                            <figure><img src="<?php echo get_template_directory_uri(); ?>/image/mail.svg"></figure>
                            <?php $email_id =  get_field('email_id','option'); ?>
                            <a href="<?php echo $email_id['url']; ?>"><?php echo $email_id['title']; ?></a>
                        </li>
                    </ul>
                    <div class="map">
                        <?php the_field('map','option'); ?>
                    </div>
                </div>
                <div class="col-md-7 col-sm-12 contact_form_grid">
                    <div class="contact_grid">
                        <div class="contact_form_area">
                        <?php the_field('contact_form_text','option'); ?>
                        <?php echo do_shortcode('[contact-form-7 id="5" title="Contact form" html_class="contact_form"]') ?>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </section> 
<?php endwhile;?>
<?php get_footer();
