<?php /* Template Name: About Template */ ?>
<?php 
get_header(); ?>
<section class="WFwrap baner_section about_banner">
        <figure class="desktop">
            <img src="<?php the_field('desktop_banner'); ?>">
        </figure>
        <figure class="mobile">
            <img src="<?php the_field('mobile_banner'); ?>">
        </figure>
        <div class="baner_content">
            <div class="container">
                <div class="baner_con_inbox">
                    <div class="title">
                       <?php the_field('banner_title'); ?>
                    </div>
                    <?php the_field('banner_dsc'); 
                    $dr_link = get_field('dr_link'); 
                    ?>
                    <a href="<?php echo $dr_link['url']; ?>" class="btn"><?php echo $dr_link['title']; ?></a>
                </div>
            </div>
        </div>
    </section>
    <section class="WFwrap about_Dr_des">
        <div class="container">
            <div class="about_Dr_inner_box">
                <div class="about_dr_description">
                    <h2><?php the_field('description_title'); ?></h2>
                    <p class="study"><?php the_field('study'); ?></p>
                    <?php the_field('description_text'); ?>
                    
                </div>
            </div>
        </div>
    </section>    
    <section class="WFwrap contact_section">
        <div class="container">
            <div class="row">
                <div class="col-md-5 col-sm-12 contact_detail_grid">
                    <h2>Our Location</h2>
                    <ul>
                        <li>
                            <figure><img src="<?php echo get_template_directory_uri(); ?>/image/location.svg"></figure>
                            <?php the_field('address','option'); ?>
                        </li>
                        <li>
                        <figure><img src="<?php echo get_template_directory_uri(); ?>/image/call.svg"></figure>
                        <?php $call_t =  get_field('call_t','option');$call_e =  get_field('call_e','option'); ?>
                        T : <a href="tel:<?php echo $call_t['url']; ?>"><?php echo $call_t['title']; ?></a><br>  
                        F : <?php the_field('call_f','option'); ?><br>
                        E : <a href="tel:<?php echo $call_e['url']; ?>"><?php echo $call_e['title']; ?></a>
                    </li>
                        <li>
                            <figure><img src="<?php echo get_template_directory_uri(); ?>/image/clock.svg"></figure><?php the_field('timer','option'); ?>
                        </li>
                        <li class="email-img">
                            <figure><img src="<?php echo get_template_directory_uri(); ?>/image/mail.svg"></figure>
                            <?php $email_id =  get_field('email_id','option'); ?>
                            <a href="<?php echo $email_id['url']; ?>"><?php echo $email_id['title']; ?></a>
                        </li>
                    </ul>
                    <div class="map">
                        <?php the_field('map','option'); ?>
                    </div>
                </div>
                <div class="col-md-7 col-sm-12 contact_form_grid">
                    <div class="contact_grid">
                        <div class="contact_form_area">
                        <?php the_field('contact_form_text','option'); ?>
                        <?php echo do_shortcode('[contact-form-7 id="5" title="Contact form" html_class="contact_form"]') ?>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </section>
<?php
get_footer();
?>