<?php /* Template Name: contact-template */ ?>
<?php 
get_header(); ?>
<section class="WFwrap contact_section">
    <div class="container">
        <div class="row">
            <div class="col-md-5 col-sm-12 contact_detail_grid">
                <h2>Our Location</h2>
                <ul>
                    <li>
                        <figure><img src="<?php echo get_template_directory_uri(); ?>/image/location.svg"></figure>
                        <?php the_field('address','option'); ?>
                    </li>
                    <li>
                        <figure><img src="<?php echo get_template_directory_uri(); ?>/image/call.svg"></figure>
                        <?php $call_t =  get_field('call_t','option');$call_e =  get_field('call_e','option'); ?>
                        T : <a href="tel:<?php echo $call_t['url']; ?>"><?php echo $call_t['title']; ?></a><br>  
                        F : <?php the_field('call_f','option'); ?><br>
                        E : <a href="tel:<?php echo $call_e['url']; ?>"><?php echo $call_e['title']; ?></a>
                    </li>
                    <li>
                        <figure><img src="<?php echo get_template_directory_uri(); ?>/image/clock.svg"></figure><?php the_field('timer','option'); ?>
                    </li>
                    <li class="email-img">
                        <figure><img src="<?php echo get_template_directory_uri(); ?>/image/mail.svg"></figure>
                        <?php $email_id =  get_field('email_id','option'); ?>
                        <a href="<?php echo $email_id['url']; ?>"><?php echo $email_id['title']; ?></a>
                    </li>
                </ul>
                <div class="map">
                    <?php the_field('map','option'); ?>
                </div>
            </div>
            <div class="col-md-7 col-sm-12 contact_form_grid">
                <div class="contact_grid">
                    <div class="contact_form_area">
                    <?php the_field('contact_form_text','option'); ?>
                    <?php echo do_shortcode('[contact-form-7 id="5" title="Contact form" html_class="contact_form" rest_api=false]') ?>
                   </div>
                </div>
            </div>
            
        </div>
    </div>
</section>
<?php
get_footer();
?>