<?php /* Template Name: Home Template */ ?>

<?php 

get_header(); ?>

	<section class="WFwrap baner_section">

        <figure class="desktop">

            <img src="<?php the_field('desktop_image'); ?>">

        </figure>

        <figure class="mobile">

            <img src="<?php the_field('mobile_image'); ?>">

        </figure>

        <div class="baner_content">

            <div class="container">

                <div class="baner_con_inbox">

                    <h1><?php the_field('banner_heading'); ?></h1>

                    <?php the_field('banner_contant');

                     $banner_link = get_field('banner_link');

                     ?>

                    <a href="<?php echo $banner_link['url']; ?>" class="btn"><?php echo $banner_link['title']; ?></a>

                </div>

            </div>
			
		</div>

    </section>

    <section class="WFwrap about_dr_section">

        <div class="container">

            <div class="row">

                <div class="col-md-6 col-sm-12 about_dr_img">

                    <figure>

                    <img src="<?php the_field('dr_image','option'); ?>">

                    </figure>

                </div>

                <div class="col-md-6 col-sm-12 about_dr_contain">

                        <div class="title">

                            <?php the_field('dr_title','option'); ?>

                        </div>

                        <p class="study"><?php the_field('dr_study','option'); ?></p>

                        <?php the_field('dr_dec','option'); 

                       	$dr_link = get_field('dr_link','option');

                        ?>

                        <a href="<?php echo $dr_link['url']; ?>" class="btn"><?php echo $dr_link['title']; ?></a>

                </div>

            </div>

        </div>

    </section>    

    <section class="WFwrap service_section">

        <div class="container">

            <div class="title">

                <h2><?php the_field('service_title'); ?></h2>

            </div>

            <?php 

            $select_services = get_field('select_service'); 

            if( $select_services ):

            ?>

            

            <ul>

            	<?php foreach( $select_services as $select_service ):

            		$post = get_post( $select_service);

            	 ?>

            		<li>

                    <div class="service_grid">

                        <figure><img src="<?php the_field('icon_image',$select_service); ?>"></figure>

                        <h5><?php echo get_the_title( $select_service); ?></h5>

                        <p><?php echo $post->post_excerpt; ?></p>

                        <a href="<?php echo get_permalink( $our_areas_grid); ?>">Read More <span><img src="<?php echo get_template_directory_uri(); ?>/image/Vector.svg"><img src="<?php echo get_template_directory_uri(); ?>/image/Vector.svg"></span></a>

                    </div>

                </li>

            	<?php endforeach; ?>

            </ul>

            <?php endif; ?>

        </div>

    </section>    

    <section class="WFwrap contact_section">

        <div class="container">

            <div class="row">

                <div class="col-md-5 col-sm-12 contact_detail_grid">

                    <h2>Our Location</h2>

                    <ul>

                        <li>

                            <figure><img src="<?php echo get_template_directory_uri(); ?>/image/location.svg"></figure>

                            <?php the_field('address','option'); ?>

                        </li>

                        <li>

                            <figure><img src="<?php echo get_template_directory_uri(); ?>/image/call.svg"></figure>

                            <?php $call_t =  get_field('call_t','option');$call_e =  get_field('call_e','option'); ?>

                            T : <a href="tel:<?php echo $call_t['url']; ?>"><?php echo $call_t['title']; ?></a><br>   

                            F : <?php the_field('call_f','option'); ?><br> 
							
							E : <a href="tel:<?php echo $call_e['url']; ?>"><?php echo $call_e['title']; ?></a>

                        </li>

                        <li>

                            <figure><img src="<?php echo get_template_directory_uri(); ?>/image/clock.svg"></figure><?php the_field('timer','option'); ?>

                        </li>

                        <li class="email-img">

                            <figure><img src="<?php echo get_template_directory_uri(); ?>/image/mail.svg"></figure>

                            <?php $email_id =  get_field('email_id','option'); ?>

                            <a href="<?php echo $email_id['url']; ?>"><?php echo $email_id['title']; ?></a>

                        </li>

                    </ul>

                    <div class="map">

                        <?php the_field('map','option'); ?>

                    </div>

                </div>

                <div class="col-md-7 col-sm-12 contact_form_grid">

                    <div class="contact_grid">

                        <div class="contact_form_area">

                        <?php the_field('contact_form_text','option'); ?>

                        <?php echo do_shortcode('[contact-form-7 id="5" title="Contact form" html_class="contact_form"]') ?>

                       </div>

                    </div>

                </div>

                

            </div>

        </div>

    </section>

<?php

get_footer();

?>